% -- sepslide.cls (c) Jim Davies 2001 ----------------------------------

% to do before full release: a4/letter page size corrections, xdvi hyperref
% functionality

\def\fileversion{1.0} \def\filedate{01/03/19}

\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{sepslide}[{\filedate\space\fileversion\space sepslide class}]

% -- functionality

\newif\if@notes@
\newif\if@slides@
\newif\if@copies@

\DeclareOption{notes}{\@notes@true}
\DeclareOption{slides}{\@slides@true}
\DeclareOption{copies}{\@copies@true}

\DeclareOption{noslides}{\@slides@false}

\DeclareOption{slidesonly}{\@notes@false\@slides@true}
\DeclareOption{notesonly}{\@notes@true\@slides@false}
\DeclareOption{article}{\@copies@true}

% -- color 

\newif\if@color@

\DeclareOption{color}{\@color@true}
\DeclareOption{monochrome}{\@color@false}

% -- drivers

\newif\if@dvipsone@
\newif\if@dvips@
\newif\if@xdvi@

\DeclareOption{dvipsone}{\@dvips@false\@xdvi@false\@dvipsone@true}
\DeclareOption{dvips}{\@dvips@true\@dvipsone@false}
\DeclareOption{xdvi}{\@xdvi@true\@color@false\@dvipsone@false}

% -- page size 

\newif\if@letter@
\newif\if@afour@

\DeclareOption{letter}{\@letter@true\@afour@false}
\DeclareOption{a4}{\@letter@false\@afour@true}

% -- defaults

\ExecuteOptions{slides,dvips,xdvi,a4} \ProcessOptions\relax


% -- seminar class -----------------------------------------------------

\LoadClass[%
  \if@slides@%
    \if@notes@%
      notes%
    \else%
      slidesonly%
    \fi%
  \else%
    notesonly%
  \fi,%
  \if@copies@%
    article%
  \fi]{seminar}  


% -- color -------------------------------------------------------------

% \@ifpackageloaded{color}{}{%
%   \RequirePackage[%
%     usenames,%
%     dvipsnames,%
%     \if@dvipsone@%
%       dvipsone,%
%     \fi%
%     \if@dvips@%
%       dvips,%
%     \fi%
%     \if@xdvi@%
%       xdvi,%
%     \fi%
%     \if@color@\else%
%       monochrome%
%     \fi%
%     ]{color}}

\usepackage{color}
\usepackage{colornames}

\if@dvips@
  \let\newcolor=\definecolor
  \def\setcolor#1#2{\relax}
\else
  \def\newcolor#1#2#3{\DefineNamedColor{named}{#1}{#2}{#3}}
  \def\setcolor#1#2{\DefineNamedColor{named}{#1}{named}{#2}}
\fi


\newcolor{AnswerColor}{cmyk}{0,0.42,1,0} % {YellowOrange}
\newcolor{AuthorColor}{cmyk}{1,1,0,0} % {Blue}
\newcolor{BulletColor}{cmyk}{0,0.61,0.87,0} %{Orange}
\newcolor{CaptionColor}{cmyk}{0,0.77,0.87,0} %{RedOrange}
\newcolor{ContentsColor}{cmyk}{0,0.61,0.87,0} %{Orange}
\newcolor{CourseColor}{cmyk}{1,1,0,0} %{Blue}
% {0.86,0.91,0,0.04} %{BlueViolet}
\newcolor{DescriptionColor}{cmyk}{0.07,0.90,0,0.34} % {RedViolet}
\newcolor{EmphasisColor}{cmyk}{1,0.50,0,0} %{RoyalBlue}
\newcolor{ExampleColor}{cmyk}{0.64,0,0.95,0.40} %{OliveGreen}
\newcolor{FadeColor}{cmyk}{0,0,0,0.50} %{Gray}
\newcolor{HeaderColor}{cmyk}{0,0,0,0.50} %{Gray}
\newcolor{HeadingColor}{cmyk}{0,1,1,0} %{Red}
\newcolor{IndexHeadingColor}{cmyk}{0,0.77,0.87,0} %{RedOrange}
\newcolor{IndexSubHeadingColor}{cmyk}{0,0.42,1,0} %{YellowOrange}
\newcolor{MathsColor}{cmyk}{0.50,1,0,0} %{Plum}
\newcolor{QuestionColor}{cmyk}{0,0.42,1,0} %{YellowOrange}
\newcolor{SubHeadingColor}{cmyk}{0,0.77,0.87,0} %{RedOrange}
\newcolor{SubtitleColor}{cmyk}{1,0.50,0,0} %{RoyalBlue}
\newcolor{TextColor}{cmyk}{1,1,0,0} %{Blue}
\newcolor{TitleBoxColor}{cmyk}{0,0.10,0.84,0} %{Goldenrod}
\newcolor{TitleColor}{cmyk}{0.86,0.91,0,0.04} %{BlueViolet}
%\newcolor{TitleColor}{cmyk}{0,0,0,0} %{White}
\newcolor{TitleShadowColor}{cmyk}{0,0,0,0.50} %{Gray}

\newcolor{LightGray}{gray}{0.8}
\newcolor{MediumGray}{gray}{0.6}
\newcolor{DarkGray}{gray}{0.4}

\newcolor{DPA}{rgb}{0.933,0.533,0.000}
\newcolor{DOB}{rgb}{0.933,0.400,0.133}
\newcolor{OOD}{rgb}{0.933,0.267,0.133}
\newcolor{OOP}{rgb}{0.933,0.133,0.133}
\newcolor{OOR}{rgb}{0.933,0.000,0.267}
\newcolor{SEM}{rgb}{0.867,0.000,0.200}
\newcolor{SDE}{rgb}{0.733,0.000,0.400}
\newcolor{FPR}{rgb}{0.800,0.000,0.600}
\newcolor{CDS}{rgb}{0.600,0.000,0.800}
\newcolor{SDM}{rgb}{0.400,0.067,0.800}
\newcolor{STE}{rgb}{0.200,0.200,0.800}
\newcolor{MRQ}{rgb}{0.000,0.400,0.800}
\newcolor{PSE}{rgb}{0.000,0.533,0.667}
\newcolor{ACT}{rgb}{0.000,0.533,0.533}
\newcolor{ASD}{rgb}{0.000,0.667,0.400}
\newcolor{MAS}{rgb}{0.133,0.800,0.267}
\newcolor{SPP}{rgb}{0.267,0.800,0.133}
\newcolor{CSE}{rgb}{0.400,0.800,0.000}
\newcolor{REN}{rgb}{0.533,0.800,0.000}
\newcolor{PMO}{rgb}{0.667,0.800,0.000}
\newcolor{PCO}{rgb}{0.933,0.267,0.133}
\newcolor{PCS}{rgb}{0.933,0.133,0.333}
\newcolor{DIP}{rgb}{0.800,0.000,0.600}
\newcolor{MSC}{rgb}{0.600,0.000,0.800}

\newcolor{Color00}{rgb}{0.95,0.00,0.30}
\newcolor{Color01}{rgb}{0.95,0.00,0.00}
\newcolor{Color02}{rgb}{0.95,0.30,0.00}
\newcolor{Color03}{rgb}{0.95,0.60,0.00}
\newcolor{Color04}{rgb}{0.95,0.85,0.00}
\newcolor{Color05}{rgb}{0.70,0.85,0.00}
\newcolor{Color06}{rgb}{0.40,0.80,0.00}
\newcolor{Color07}{rgb}{0.00,0.75,0.00}
\newcolor{Color08}{rgb}{0.00,0.80,0.30}
\newcolor{Color09}{rgb}{0.00,0.80,0.60}
\newcolor{Color10}{rgb}{0.00,0.80,0.80}
\newcolor{Color11}{rgb}{0.00,0.60,0.85}
\newcolor{Color12}{rgb}{0.00,0.40,0.85}
\newcolor{Color13}{rgb}{0.00,0.00,0.80}
\newcolor{Color14}{rgb}{0.40,0.00,0.85}
\newcolor{Color15}{rgb}{0.70,0.00,0.85}
\newcolor{Color16}{rgb}{0.85,0.00,0.80}
\newcolor{Color17}{rgb}{0.90,0.00,0.60}
\newcolor{Color18}{rgb}{0.95,0.00,0.30}
\newcolor{Color19}{rgb}{0.95,0.00,0.00}
\newcolor{Color20}{rgb}{0.95,0.30,0.00}

\if@color@
  \def\emph#1{{\color{EmphasisColor} #1}}
  \def\em{\color{EmphasisColor}}
  \def\fade#1{{\color{FadeColor}#1}}
\else
  \def\fade#1{\phantom{#1}}
\fi

% -- colour versions of standard macros --------------------------------

\def\labelitemi{{\color{BulletColor}$\m@th\bullet$}}
\def\labelitemii{{\color{BulletColor}\normalfont\bfseries --}}
\def\labelitemiii{{\color{BulletColor}$\m@th\ast$}}
\def\labelitemiv{{\color{BulletColor}$\m@th\cdot$}}

\def\labelenumi{{\color{BulletColor}\theenumi.}}
\def\labelenumii{({\color{BulletColor}\theenumii})}
\def\labelenumiii{{\color{BulletColor}\theenumiii.}}
\def\labelenumiv{{\color{BulletColor}\theenumiv.}}

\def\descriptionlabel#1{\hspace\labelsep
                                \normalfont\bfseries \color{DescriptionColor}#1}


\def\({\relax\ifmmode\@badmath\else\bgroup\color{MathsColor}$\fi}
\def\){\relax\ifmmode\ifinner$\egroup\else\@badmath\fi\else\@badmath\fi}
\let\math=\(
\let\endmath=\)

\@ifpackageloaded{zed}{\relax}{%
  \renewcommand\[{%
    \relax\ifmmode\@badmath\else%
    \bgroup\color{MathsColor}
    \begin{trivlist}%
      \@beginparpenalty\predisplaypenalty
      \@endparpenalty\postdisplaypenalty
    \item[]\leavevmode
      \hb@xt@\linewidth\bgroup$\m@th\displaystyle %$
      \hskip \mathindent\bgroup
      \fi}
    
    \renewcommand\]{\relax
      \ifmmode
      \egroup $\hfil% $
      \egroup
    \end{trivlist} \egroup%
    \else \@badmath
    \fi}
  }

\ifx\mathindent\undefined
  \newdimen\mathindent
  \AtEndOfPackage{\mathindent\leftmargini}
\fi

\renewenvironment{equation}%
    {\@beginparpenalty\predisplaypenalty
     \@endparpenalty\postdisplaypenalty
     \refstepcounter{equation}%
     \bgroup\color{MathsColor}%
     \trivlist\item[]\leavevmode
       \hb@xt@\linewidth\bgroup $\m@th% $
         \displaystyle
         \hskip\mathindent}%
        {$\hfil % $
         \displaywidth\linewidth\hbox{\@eqnnum}%
       \egroup
     \endtrivlist\egroup}

% \renewenvironment{eqnarray}{%
%     \stepcounter{equation}%
%     \def\@currentlabel{\p@equation\theequation}%
%     \global\@eqnswtrue\m@th
%     \global\@eqcnt\z@
%     \tabskip\mathindent
%     \let\\=\@eqncr
%     \bgroup\color{MathsColor}
%     $$\everycr{}\halign to\linewidth% $$
%     \bgroup
%       \hskip\@centering
%       $\displaystyle\tabskip\z@skip{##}$\@eqnsel&%
%       \global\@eqcnt\@ne \hskip \tw@\arraycolsep \hfil${##}$\hfil&%
%       \global\@eqcnt\tw@ \hskip \tw@\arraycolsep
%         $\displaystyle{##}$\hfil \tabskip\@centering&%
%       \global\@eqcnt\thr@@
%         \hb@xt@\z@\bgroup\hss##\egroup\tabskip\z@skip\cr}%
%       {\@@eqncr
%     \egroup
%     \global\advance\c@equation\m@ne$$\egroup\global\@ignoretrue}

\renewenvironment{eqnarray}{\[\begin{array}[t]{@{}rcl@{}}}{\end{array}\]\@ignoretrue}

\settowidth\arraycolsep{$\hbox{}\;{\mathrel{\hbox{}}}\;\hbox{}$}
\divide\arraycolsep by 4

\def\everyslide{\color{TextColor}}


% -- hyperref ----------------------------------------------------------

\RequirePackage{slidesec}

\RequirePackage[%
  pageanchor=false,%
  pdfpagemode=None,%
  \if@dvips@%
    dvips,%
  \fi%
  \if@dvipsone@%
    dvipsone,%
  \fi%
  \if@afour@%
    a4paper,%
  \fi
  hyperindex, backref]{hyperref}

\def\@pdfborder{0 0 0}


% -- slide and page styles ---------------------------------------------

\def\slidenumber{\ifnum\theslide<10 0\fi\arabic{slide}}

\newcounter{slides}
\setcounter{slides}{1}

\def\theslides{\arabic{slides}}

\def\forslides{%
  \theslides\ \&\ \addtocounter{slides}{1}%
  \theslides\addtocounter{slides}{1}}

\newpagestyle{sepslide}{%
  {\color{HeaderColor}{\@slidetopleft\hfill\@slidetopright}}%
  }{%
  {\color{HeaderColor}{\@slidebottomleft\hfill\@slidebottomright}}}

\slidepagestyle{sepslide}

\newpagestyle{seppage}{%
  {\color{HeaderColor}\ifodd\c@page\@pagetopleft\else\@pagetopright\fi}%
  }{%
  {\color{HeaderColor}\ifodd\c@page\@pagebottomleft\else\@pagebottomright\fi}%
  }

\pagestyle{seppage}

\def\slidetopleft#1{\gdef\@slidetopleft{#1}}
\def\slidetopright#1{\gdef\@slidetopright{#1}}
\def\slidebottomleft#1{\gdef\@slidebottomleft{#1}}
\def\slidebottomright#1{\gdef\@slidebottomright{#1}}

\def\pagetopleft#1{\gdef\@pagetopleft{#1}}
\def\pagetopright#1{\gdef\@pagetopright{#1}}
\def\pagebottomleft#1{\gdef\@pagebottomleft{#1}}
\def\pagebottomright#1{\gdef\@pagebottomright{#1}}

\def\indexfile#1{\gdef\@indexfile{#1}}

\slidetopleft{\@title} 
%\slidetopleft{\includegraphics[height=43pt]{header.eps}} 

\slidetopright{\hyperlink{listofslides}{\slidenumber}}
\slidebottomleft{\mbox{}} 
\slidebottomright{\mbox{}}

\pagetopleft{\forslides\hfill\textsl{\@title}}
\pagetopright{\textsl{\@title}\hfill\forslides}
\pagebottomleft{\mbox{}\hfill} 
\pagebottomright{\hfill\mbox{}}

\indexfile{slides00.pdf}

\slidestyle{empty}
\slideframe{none}


% -- title, subtitle, author, course, topic ----------------------------

\RequirePackage{fancybox} 

\def\Title{\@ifnextchar[{\@Title}{\@Title[\@title]}}

\def\@Title[#1]{%
  \null\vfill%
  \begin{center}%
    \huge\bfseries%
    \color{TitleShadowColor}\fboxsep 0pt%
    \if@color@\fboxrule 0pt\else\fboxrule 0.4pt\fi%
          \color{TitleColor}%
          \begin{minipage}{0.85\textwidth}%
            \leftmargin0.5\baselineskip\rightmargin\leftmargin%
            \vspace{0.5\baselineskip}%
            \begin{center}%
              #1%
            \end{center}%
            \vspace{0.5\baselineskip}%
          \end{minipage}%
    \end{center}%
    \vfill%
    \small%
    \begin{flushright}%
      \color{SubtitleColor}\@subtitle \\%
      \color{AuthorColor}\@author%
    \end{flushright}
    }

\def\@Title[#1]{%
  \null\vfill%
  \begin{center}%
    \huge\bfseries%
    \color{TitleShadowColor}\fboxsep 0pt%
    \if@color@\fboxrule 0pt\else\fboxrule 0.4pt\fi%
      \shadowbox{%
        \colorbox{TitleBoxColor}{%
          \color{TitleColor}%
          \begin{minipage}{0.66\textwidth}%
            \leftmargin0.5\baselineskip\rightmargin\leftmargin%
            \vspace{0.5\baselineskip}%
            \begin{center}%
              #1%
            \end{center}%
            \vspace{0.5\baselineskip}%
          \end{minipage}}}%
    \end{center}%
    \vfill%
    \small%
    \begin{flushright}%
      \color{SubtitleColor}\@subtitle \\%
      \color{AuthorColor}\@author%
    \end{flushright}
    }    
    
    

\def\author#1{\gdef\@author{#1}}
\def\title#1{\gdef\@title{#1}}
\def\subtitle#1{\gdef\@subtitle{#1}}

\author{\mbox{}} \title{\mbox{}} \subtitle{\mbox{}}

\def\course{\@ifnextchar[{\two@coursename}{\one@coursename}}
\def\one@coursename#1{\two@coursename[#1]{#1}}
\def\two@coursename[#1]#2#3{%
  \def\courseshortname{#1}%
  \def\courselongname{#2}%
  \setcolor{CourseColor}{#3}%
  \setcolor{SubtitleColor}{CourseColor}%
  \slidetopleft{\href{\@indexfile}{#1}}%
  \pagetopleft{#1}%
  \subtitle{#2}}

\def\courselongname{\mbox{}}
\def\courseshortname{\mbox{}}

\def\topic#1#2{\@ifnextchar[{\@topic{#1}{#2}}{\@topic{#1}{#2}[Color#1]}}

\def\@topic#1#2[#3]{%
  \def\topicnumber{#1}%
  \def\topicname{#2}%
  \title{#2}%
  \setcolor{TitleBoxColor}{#3}%
  \slidetopright{\hyperlink{listofslides}{\topicnumber--\slidenumber}}%
  \pagetopright{\topicnumber\quad\topicname}}


% -- headings ----------------------------------------------------------

\def\Heading{\Colorheading{HeadingColor}}
\let\heading=\Heading

\def\Subheading{\Colorsubheading{HeadingColor}}
\let\subheading=\Subheading

\def\Colorheading#1{\def\thisheadingcolor{#1}\slideheading}

\def\Colorsubheading#1{\def\thisheadingcolor{#1}\slidesubheading}

\def\makeslideheading#1{\bgroup\color{\thisheadingcolor}\large\bfseries
  #1\egroup\vspace{1.2ex}}

\def\makeslidesubheading#1{\bgroup\color{\thisheadingcolor}\large
  #1\egroup\vspace{1.2ex}}

\def\Question{\Colorsubheading{QuestionColor}{Question}}
\def\Answer{\Colorsubheading{AnswerColor}{Answer}}

\def\Exampleheading#1{\Colorsubheading{ExampleColor}{#1}}

\def\Example{\@ifnextchar[{\@example}{\Exampleheading{Example}}}
\def\Examples{\@ifnextchar[{\@examples}{\Exampleheading{Examples}}}
\def\@example[#1]{\Exampleheading{Example: #1}}
\def\@examples[#1]{\Exampleheading{Examples: #1}}

\def\Blankheading{\bgroup\color{White}\large
  Example\egroup\vspace{1.2ex}}

\def\Contentsheading#1{\bgroup\color{ContentsColor}\large
  #1\egroup\vspace{1.2ex}}

\def\switch#1#2#3{%
  \vfill
  \begin{flushright}
    \hypertarget{#1}{%
    \hyperlink{#2}{\color{FadeColor}see: #3}}
  \end{flushright}}

\def\teleport#1#2#3{%
  \@ifnextchar[{\color@teleport{#1}{#2}{#3}}{\plain@teleport{#1}{#2}{#3}}}

\def\color@teleport#1#2#3[#4]{%
  \hypertarget{#1}{\hyperlink{#2}{\color{#4}#3}}}

\def\plain@teleport#1#2#3{%
  \hypertarget{#1}{\hyperlink{#2}{#3}}}

\def\wormhole#1#2#3#4#5#6{%
  \hyperdef{#1}{#2}{\hyperref{#3}{#4}{#5}{#6}}}

% local_cat, local_name, remote_doc, remote_cat, remote_name, text


% -- navigation pages --------------------------------------------------

\def\Contents{%
  \Contentsheading{Contents}
  \hyperdef{heading}{contents}{\null}
  \vspace{\abovedisplayshortskip}%
  \def\l@slide##1##2##3##4{%
    \slide@undottedcline{%
      \slidenumberline{%
        \color{BulletColor}$\bullet$}{%
        \hyperlink{##4}{{##2}}}}{##3}}%
  \let\l@subslide\@gobblefour%
  \@startlos}

\def\Location{%
  \Contentsheading{Location}%
  \vspace{\abovedisplayshortskip}%
  \def\l@slide##1##2##3##4{%
    \ifcase\lslide@flag%
      \message{##1 ** \the\c@slidesection}%
      \ifnum##1>\c@slidesection%
        \def\lslide@flag{1}{\slide@undottedcline{%
          \slidenumberline{\color{BulletColor}$\Rightarrow\bullet$}{%
            \hyperlink{##4}{##2}}}{##3}}%
      \else
        {\slide@undottedcline{%
          \slidenumberline{\color{BulletColor}$\surd\;\bullet$}{%
            \hyperlink{##4}{##2}}}{##3}}%
      \fi
    \or
      \def\lslide@flag{2}{\slide@undottedcline{%
        \slidenumberline{\color{BulletColor}$\bullet$}{%
          \hyperlink{##4}{##2}}}{##3}}%
    \or
      {\slide@undottedcline{%
        \slidenumberline{\color{BulletColor}$\bullet$}{%
          \hyperlink{##4}{{##2}}}}{##3}}%
    \fi}%
  \let\l@subslide\@gobblefour%
  \def\lslide@flag{0}%
  \@startlos}

\def\Summary{%
  \Contentsheading{Summary}%
  \vspace{\abovedisplayshortskip}%
  \def\l@slide##1##2##3##4{%
    \slide@undottedcline{%
      \slidenumberline{%
        \color{BulletColor}$\bullet$}{%
        \hyperlink{##4}{{##2}}}}{##3}}%
  \let\l@subslide\@gobblefour
  \@startlos}

\def\Listofslides{%
  \ifarticle\else%
  \hypertarget{listofslides}{\Contentsheading{Index}}%
  \vspace{\abovedisplayskip}%
  \def\l@slide##1##2##3##4{%
    \slide@undottedcline{%
      \color{HeaderColor}\slidenumberline{##3}{%
        \hyperlink{##4}{\color{IndexHeadingColor}##2}}}{}}%
  \def\l@subslide##1##2##3##4{%
    \slide@undottedcline{\color{HeaderColor}\slidenumberline{##3}{%
        \hyperlink{##4}{\color{IndexSubHeadingColor}##2}}}{}}%
  \@startlos\fi}

\def\theslidesubsection{\theslidesection.\arabic{slidesubsection}}


% -- timetable page ----------------------------------------------------

\newcount\starthours \newcount\startminutes %
\newcount\finishhours \newcount\finishminutes

\def\fullday#1{{\hbox to \daywidth{\hss%
      \vbox to \tableheight{%
        #1%
        \entry{MediumGray}{White}{1029}{1101}{coffee}{}%
        \entry{MediumGray}{White}{1229}{1331}{lunch}{}%
        \entry{MediumGray}{White}{1459}{1531}{tea}{}%
        \vss}%
      \hss}}}

\def\halfday#1{{\hbox to \daywidth{\hss%
    \vbox to \tableheight{%
      #1%
      \entry{MediumGray}{White}{1029}{1101}{coffee}{}%
      \entry{MediumGray}{White}{1229}{1331}{lunch}{}%
      \vss}%
    \hss}}}


% entry: boxcolor, textcolor, starttime, finishtime, text, link

\def\entry#1#2#3#4#5#6{%
  \def\hyper{#6}%
  %%
  \begingroup%
  %%
  \def\thisstart{\number #3}\def\thisfinish{\number #4}%
  %%
  \starthours\thisstart \divide\starthours 100%
  \startminutes=-\starthours \multiply\startminutes 100%
  \advance\startminutes\thisstart \multiply\starthours 60%
  \advance\startminutes\starthours%
  %%
  \finishhours \thisfinish \divide\finishhours 100%
  \finishminutes=-\finishhours \multiply\finishminutes 100%
  \advance\finishminutes\thisfinish \multiply\finishhours 60%
  \advance\finishminutes\finishhours%
  %%
  \advance\finishminutes-\startminutes%
  \advance\startminutes-\tablestart%
  %%
  \multiply\starttime\startminutes%
  \multiply\finishtime\finishminutes%
  %%
  \vbox to 0mm{%
    \vskip\starttime%
    \vbox{%
      \colorbox{#1}{%
        \ifx\hyper\empty%
        \vbox to \finishtime{\vss\hbox to \daywidth{\hss%
            \color{#2}\tabular{@{}c@{}}#5\endtabular\hss}\vss}%
        \else%
        \href{#6}{\vbox to \finishtime{\vss\hbox to \daywidth{%
              \color{#2}\hss\tabular{@{}c@{}}#5\endtabular\hss}\vss}}%
        \fi}}%
    \vss}%
  \endgroup%
  }

\newdimen\tableunit \tableunit=7mm \divide\tableunit 60
\newcount\tablestart \tablestart 510 % 0830 a.m.
\newcount\tableduration \tableduration 540 % 9 hours

\newdimen\starttime \starttime\tableunit
\newdimen\finishtime \finishtime\tableunit
\newdimen\tableheight \tableheight\tableunit
\multiply\tableheight\tableduration

\newdimen\daywidth \daywidth 22mm

\def\bleed{\kern-0.1mm\relax}

\def\timetable#1#2{%
  \def\Timetable{%
    \timetablefont%
    \color{DarkGray}%
    \fboxsep 0pt%
    \if@color@\fboxrule 0pt\else\fboxrule 0.4pt\fi%
    \def\arraystretch{1}%
    \null\vskip\baselineskip%
    \begin{center}%
      {\color{CourseColor}\bfseries{\def\\{}\courselongname}} \\[2ex]%
      \begin{tabular}{@{\kern -3mm}c@{\bleed}c@{\bleed}c@{\bleed}%
          c@{\bleed}c@{\bleed}c@{\kern -3mm}}%
        #1 \\[-1ex]%
        #2%
      \end{tabular}%
    \end{center}}}%

\def\Timetable{\mbox{}}

\def\timetablefont{\footnotesize}

\def\Smalltimetable{%
  \def\timetablefont{\scriptsize}%
  \tableunit 4mm%
  \Timetable}

\if@color@\else\def\colorbox#1#2{%
  \def\@bg{White}\def\@tc{#1}%
  \ifx\@tc\@bg\hbox{#2}\else\fbox{#2}\fi}\fi


% -- graphics ----------------------------------------------------------

\@ifpackageloaded{graphicx}{}{%
  \RequirePackage[%
    \if@dvips@%
      dvips%
    \fi%
    \if@dvipsone@%
      dvipsone%
    \fi]{graphicx}}

\def\slidefigure{\@ifnextchar[{\optionalslidefigure}{\plainslidefigure}}

\def\optionalslidefigure[#1]#2{\begin{center}\leavevmode%
    \includegraphics[#1]{#2}\end{center}}

\def\plainslidefigure#1{\begin{center}\leavevmode%
    \includegraphics{#1}\end{center}}

\def\slidecaption#1{\bgroup\center\normalfont\sffamily%
  \color{CaptionColor}#1\endcenter\egroup%
  \vspace{-\belowdisplayskip}}


% -- seminar itself ----------------------------------------------------


\def\slideleftmargini{2em}
\def\slideleftmarginii{1.5em}
\def\slideleftmarginiii{1em}

\leftmargini 25pt
\leftmarginii 22pt
\leftmarginiii 18.7pt
\leftmarginiv 17pt
\leftmarginv 10pt
\leftmarginvi 10pt

\leftmargin\leftmargini \labelsep 5pt
\labelwidth\leftmargini \advance\labelwidth-\labelsep

\parindent=\leftmargini

\centerslidesfalse

\def\paperwidth{210mm}
\def\paperheight{297mm}

\slidewidth 222mm
\slideheight 163mm % 152 default

\def\slideleftmargin{12mm}
\def\sliderightmargin{12mm}
\def\slidetopmargin{12mm}
\def\slidebottommargin{12mm}

\ifarticle
  \ifportrait
    \twocolumn
    \sloppy
    \topmargin 0pt
    \headheight 15pt
    \headsep 25pt
    \footskip 30pt
    \footheight 15pt
    \textheight\paperwidth\relax
    \advance\textheight -1in
    \advance\textheight -\headsep
    \advance\textheight -\headheight
    \advance\textheight -\footskip
    \advance\textheight -\footheight
    \advance\textheight -.5in
    \textwidth\paperheight\relax
    \advance\textwidth by -2in
    \oddsidemargin 0pt
    \evensidemargin 0pt
    \leftmargini 2em
    \leftmarginv .5em
    \leftmarginvi .5em
    \columnsep  40pt
    \marginparwidth 0pt
    \marginparsep 0pt
  \else
    \typeout{^^J preparing copies of slides ^^J}%
    \@twosidetrue%
    \advance\textheight -28mm
    \advance\topmargin 30.5mm
    \advance\headsep -6mm
    \advance\headheight -1mm
    \footheight 0pt
    \footskip 0pt
    \input 2up.tex
    \source{\magstep0}{210mm}{297mm}
    \target{\magstep0}{297mm}{210mm}
    \advance\textwidth -11mm
    \advance\evensidemargin 2.5mm
    \advance\oddsidemargin 2.5mm
    \printlandscapetrue
    \if@dvips@
    \def\printlandscape{\special{papersize=297mm,210mm}}
    \else
    \def\printlandscape{\special{landscape}}
    \fi
  \fi
\else
  \typeout{^^J making slides ^^J}
  \oddsidemargin 0pt
  \evensidemargin 0pt
  \marginparwidth 0pt
  \marginparsep 0pt
  \ifportrait
    \textwidth\paperwidth\relax
    \textheight\paperheight\relax
  \else
    \textwidth\paperheight\relax
    \textheight\paperwidth\relax
  \fi
  \advance\textwidth by -2in
  \topmargin -1in
  \headheight .5in
  \headsep .5in
  \advance\textheight by -2in
  \footskip .75in
  \footheight .25in
  \printlandscapetrue
  \if@dvips@
  \def\printlandscape{\special{papersize=297mm,210mm}}
  \else
  \def\printlandscape{\special{landscape}}
  \fi
\fi


% ----------------------------------------------------------------------


\endinput


% ----------------------------------------------------------------------

